% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inftheo.R
\name{mutual_info}
\alias{mutual_info}
\title{Mutual information MI(X;Y) = H(X) - H(X|Y) = H(Y) - H(Y|X)}
\usage{
mutual_info(.data, ..., normalized = FALSE, na.rm = FALSE)
}
\arguments{
\item{.data}{A tibble with the column of interest}

\item{...}{two columns (variables) selected}

\item{normalized}{if TRUE, scale from 0 to 1}

\item{na.rm}{remove all rows with NA values in at least one of the columns}
}
\value{
a double with the calculated value
}
\description{
This calculates the mutual information between two variables in a tibble.
(if normalized).  It's assumed these columns are character typed with no NAs.
}
\examples{
# make an all-character version of mtchars
mt_tib <- as_tibble(mtcars) \%>\% mutate_all(as.character)
mutual_info(mt_tib, vs, am)
mutual_info(mt_tib, 'am', 'vs')
mutual_info(mt_tib, vs, am, normalized=TRUE)
mutual_info(mt_tib, starts_with('c'))
}
