% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openai.R
\name{send_openai_batch}
\alias{send_openai_batch}
\title{Send a Batch of Messages to OpenAI Batch API}
\usage{
send_openai_batch(
  .llms,
  .model = "gpt-4o",
  .max_completion_tokens = NULL,
  .frequency_penalty = NULL,
  .logit_bias = NULL,
  .logprobs = FALSE,
  .top_logprobs = NULL,
  .presence_penalty = NULL,
  .seed = NULL,
  .stop = NULL,
  .temperature = NULL,
  .top_p = NULL,
  .dry_run = FALSE,
  .overwrite = FALSE,
  .json_schema = NULL,
  .max_tries = 3,
  .timeout = 60,
  .verbose = FALSE,
  .id_prefix = "tidyllm_openai_req_"
)
}
\arguments{
\item{.llms}{A list of LLMMessage objects containing conversation histories.}

\item{.model}{Character string specifying the OpenAI model version (default: "gpt-4o").}

\item{.max_completion_tokens}{Integer specifying the maximum tokens per response (default: NULL).}

\item{.frequency_penalty}{Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far.}

\item{.logit_bias}{A named list modifying the likelihood of specified tokens appearing in the completion.}

\item{.logprobs}{Whether to return log probabilities of the output tokens (default: FALSE).}

\item{.top_logprobs}{An integer between 0 and 20 specifying the number of most likely tokens to return at each token position.}

\item{.presence_penalty}{Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far.}

\item{.seed}{If specified, the system will make a best effort to sample deterministically.}

\item{.stop}{Up to 4 sequences where the API will stop generating further tokens.}

\item{.temperature}{What sampling temperature to use, between 0 and 2. Higher values make the output more random.}

\item{.top_p}{An alternative to sampling with temperature, called nucleus sampling.}

\item{.dry_run}{Logical; if TRUE, returns the prepared request object without executing it (default: FALSE).}

\item{.overwrite}{Logical; if TRUE, allows overwriting an existing batch ID associated with the request (default: FALSE).}

\item{.json_schema}{A JSON schema object as R list to enforce the output structure (default: NULL).}

\item{.max_tries}{Maximum number of retries to perform the request (default: 3).}

\item{.timeout}{Integer specifying the request timeout in seconds (default: 60).}

\item{.verbose}{Logical; if TRUE, additional info about the requests is printed (default: FALSE).}

\item{.id_prefix}{Character string to specify a prefix for generating custom IDs when names in \code{.llms} are missing (default: "tidyllm_openai_req_").}
}
\value{
An updated and named list of \code{.llms} with identifiers that align with batch responses, including a \code{batch_id} attribute.
}
\description{
This function creates and submits a batch of messages to the OpenAI Batch API for asynchronous processing.
}
