% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_claude.R
\name{check_claude_batch}
\alias{check_claude_batch}
\title{Check Batch Processing Status for Claude API}
\usage{
check_claude_batch(
  .llms = NULL,
  .batch_id = NULL,
  .api_url = "https://api.anthropic.com/",
  .dry_run = FALSE,
  .max_tries = 3,
  .timeout = 60
)
}
\arguments{
\item{.llms}{A list of LLMMessage objects}

\item{.batch_id}{A manually set batchid}

\item{.api_url}{Character; base URL of the Claude API (default: "https://api.anthropic.com/").}

\item{.dry_run}{Logical; if TRUE, returns the prepared request object without executing it (default: FALSE).}

\item{.max_tries}{Maximum retries to peform request}

\item{.timeout}{Integer specifying the request timeout in seconds (default: 60).}
}
\value{
A tibble with information about the status of batch processing
}
\description{
This function retrieves the processing status and other details of a specified Claude batch ID
from the Claude API.
}
