% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_gemini.R
\name{gemini}
\alias{gemini}
\title{Google Gemini Provider Function}
\usage{
gemini(..., .called_from = NULL)
}
\arguments{
\item{...}{Parameters to be passed to the appropriate Gemini-specific function,
such as model configuration, input text, or API-specific options.}

\item{.called_from}{An internal argument specifying which action (e.g.,
\code{chat}, \code{embed}) the function is invoked from.
This argument is automatically managed by the \code{tidyllm} verbs and should not be modified by the user.}
}
\value{
The result of the requested action, depending on the specific function invoked
(e.g., an updated \code{LLMMessage} object for \code{chat()}).
}
\description{
The \code{gemini()} function acts as a provider interface for interacting with the Google Gemini API
through \code{tidyllm}'s main verbs such as \code{chat()} and \code{embed()}.
It dynamically routes requests to Gemini-specific functions
like \code{gemini_chat()} and \code{gemini_embedding()} based on the context of the call.
}
\details{
Some functions, such as \code{gemini_upload_file()} and \code{gemini_delete_file()},
are specific to Gemini and do not have general verb counterparts.
}
