% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tx_rtt.R
\name{tx_rtt}
\alias{tx_rtt}
\title{Subset Rows of Previously Inactive Clients Who are Now Active}
\usage{
tx_rtt(old_data, new_data, states = .s, facilities = .f, status = "calculated")
}
\arguments{
\item{old_data}{The initial dataframe containing the list of clients who
have been previously inactive.}

\item{new_data}{The current datafame where changes in current treatment
status will be checked.}

\item{states}{The name(s) of the State(s) of interest. The default utilizes all
the states in the dataframe. If specifying more than one state, combine the
states using the \code{c()} e.g. \code{c("State 1", "State 2")}.}

\item{facilities}{The name(s) of the facilit(ies) of interest. Default is to utilize
all the facilities contained in the dataframe. If specifying more than one
facility, combine the facilities using the \code{c()} e.g.
\code{c("Facility 1", "Facility 2")}.}

\item{status}{Determines how the number of active clients is calculated.
The options are to either to use the NDR current_status_28_days column
or the derived current_status column ("calculated").}
}
\value{
tx_rtt
}
\description{
Generates the line-list of clients who were inactive in the data supplied to
the \code{old_data} argument but have now become active in the data supplied
to the \code{new_data} argument.
}
\examples{
\donttest{
file_path <- "https://raw.githubusercontent.com/stephenbalogun/example_files/main/ndr_example.csv"
ndr_old <- read_ndr(file_path, time_stamp = "2021-02-15")
ndr_new <- ndr_example
tx_rtt(ndr_old, ndr_new)
}

## Determine RTT for a particular state
\donttest{
tx_rtt(ndr_old, ndr_new, states = "State 1")
}
}
