% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nested_data_matrix.R
\name{nested_analysis}
\alias{nested_analysis}
\title{Perform an analysis on a nested data matrix}
\usage{
nested_analysis(
  .data,
  .fun,
  ...,
  .output_column = "model",
  .reserved_names = NULL,
  .env = parent.frame()
)
}
\arguments{
\item{.data}{A data frame with a list column of data frames, possibly created using
\link{nested_data}.}

\item{.fun}{A model function}

\item{...}{Passed to fun}

\item{.output_column}{A column name in which the output of .fun should be stored.}

\item{.reserved_names}{Names that should not be allowed as columns in any
data frame within this object}

\item{.env}{Passed to \link[rlang:as_function]{as_function}}
}
\value{
.data with an additional list column of fun output
}
\description{
Perform an analysis on a nested data matrix
}
\examples{
nd <- nested_data(
  alta_lake_geochem,
  qualifiers = c(age, depth, zone),
  key = param,
  value = value,
  trans = scale
)

na <- nested_analysis(nd, vegan::rda, X = data)
plot(na)

}
