% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-missing-column.R
\name{add_missing_column}
\alias{add_missing_column}
\title{Add missing columns to a data frame}
\usage{
add_missing_column(
  .data,
  ...,
  .before = NULL,
  .after = NULL,
  .name_repair = c("check_unique", "unique", "universal", "minimal")
)
}
\arguments{
\item{.data}{Data frame to append to.}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}>
Name-value pairs, passed on to \code{\link[tibble:tibble]{tibble()}}. All values must have
the same size of \code{.data} or size 1.}

\item{.before, .after}{One-based column index or column name where to add the
new columns, default: after last column.}

\item{.name_repair}{Treatment of problematic column names:
\itemize{
\item \code{"minimal"}: No name repair or checks, beyond basic existence,
\item \code{"unique"}: Make sure names are unique and not empty,
\item \code{"check_unique"}: (default value), no name repair, but check they are
\code{unique},
\item \code{"universal"}: Make the names \code{unique} and syntactic
\item a function: apply custom name repair (e.g., \code{.name_repair = make.names}
for names in the style of base R).
\item A purrr-style anonymous function, see \code{\link[rlang:as_function]{rlang::as_function()}}
}

This argument is passed on as \code{repair} to \code{\link[vctrs:vec_as_names]{vctrs::vec_as_names()}}.
See there for more details on these terms and the strategies used
to enforce them.}
}
\value{
The original data frame with missing columns added
if not already present.
}
\description{
This is a convenient way to add one more columns (if not already present) to
an existing data frame. It is useful to ensure that all required columns
are present in a data frame.
}
\details{
It is wrapper on \code{\link[tibble:add_column]{tibble::add_column()}} that doesn't error if the column
is already present.
}
\examples{
data <- tibble::tibble(x = 1:3, y = 3:1)

tibble::add_column(data, z = -1:1, w = 0)
add_missing_column(data, z = -1:1, .before = "y")

# add_column errors if already present
try(tibble::add_column(data, x = 4:6))

# add_missing_column silently ignores
add_missing_column(data, x = 4:6)
}
\seealso{
\code{\link[tibble:add_column]{tibble::add_column()}}
}
