% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/only.R
\name{only}
\alias{only}
\title{Extract the only distinct value from a vector}
\usage{
only(x, na_rm = FALSE)
}
\arguments{
\item{x}{An atomic vector.}

\item{na_rm}{A flag indicating whether to exclude missing values.}
}
\value{
The only distinct value from a vector otherwise throws an error.
}
\description{
Extracts the only distinct value from an atomic vector
or throws an informative error if no values or multiple distinct values.
}
\details{
\code{only()} is useful when summarizing a vector by group
while checking the assumption that it is constant within the group.
}
\examples{
only(c(1, 1))
only(c(NA, NA))
only(c(1, 1, NA), na_rm = TRUE)
try(only(character(0)))
try(only(c(1, NA)))
try(only(c(1, 2)))
}
\seealso{
\code{\link[dplyr:nth]{dplyr::first()}}
}
