% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str-detect2.R
\name{str_detect2}
\alias{str_detect2}
\title{Detect the presence/absence of a match}
\usage{
str_detect2(string, pattern, negate = FALSE)
}
\arguments{
\item{string}{Input vector. Either a character vector, or something
coercible to one.}

\item{pattern}{Pattern to look for.

The default interpretation is a regular expression, as described in
\code{vignette("regular-expressions")}. Use \code{\link[stringr:regex]{regex()}} for finer control of the
matching behaviour.

Match a fixed string (i.e. by comparing only bytes), using
\code{\link[stringr:fixed]{fixed()}}. This is fast, but approximate. Generally,
for matching human text, you'll want \code{\link[stringr:coll]{coll()}} which
respects character matching rules for the specified locale.

Match character, word, line and sentence boundaries with
\code{\link[stringr:boundary]{boundary()}}. An empty pattern, "", is equivalent to
\code{boundary("character")}.}

\item{negate}{If \code{TRUE}, return non-matching elements.}
}
\value{
A logical vector the same length as \code{string}/\code{pattern}.
}
\description{
Vectorised over \code{string} and \code{pattern}.
Actually equivalent to \code{grepl(pattern, x)} as returns FALSE
for \code{NA}s (unlike \code{\link[stringr:str_detect]{stringr::str_detect()}}).
This behavior is useful when searching comments many of which are NA to
indicate no comments present.
}
\examples{
x <- c("b", NA, "ab")
pattern <- "^a"
grepl(pattern, x)
stringr::str_detect(x, pattern)
str_detect2(x, pattern)
}
\seealso{
\code{\link[=grepl]{grepl()}} and \code{\link[stringr:str_detect]{stringr::str_detect()}}
}
