% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_has_imputed.R
\name{gt_has_imputed}
\alias{gt_has_imputed}
\title{Checks if a \code{gen_tibble} has been imputed}
\usage{
gt_has_imputed(x)
}
\arguments{
\item{x}{a \code{gen_tibble}}
}
\value{
boolean TRUE or FALSE depending on whether the dataset has been
imputed
}
\description{
This function checks if a dataset has been imputed. Note that having
imputation does not mean that the imputed values are used.
}
\examples{
example_gt <- load_example_gt("gen_tbl")

# The initial gen_tibble contains no imputed values
example_gt \%>\% gt_has_imputed()

# Now impute the gen_tibble
example_gt <- example_gt \%>\% gt_impute_simple()

# And we can check it has been imputed
example_gt \%>\% gt_has_imputed()
}
