% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_dplyr.R
\name{show_dplyr}
\alias{show_dplyr}
\title{Show dplyr code equivalent to a SQL query}
\usage{
show_dplyr(data, sql)
}
\arguments{
\item{data}{a data frame or data frame-like object (optional)}

\item{sql}{a character string containing a SQL \code{SELECT} statement}
}
\description{
\code{show_dplyr} takes a SQL \code{SELECT} statement and prints
  equivalent dplyr code
}
\details{
For more details, see \code{\link{query}}. Instead of running the
  dplyr code like \code{query} does, \code{show_dplyr} prints the dplyr code.

  In function calls in the printed code, long lists of arguments may be
  truncated and appended with \code{...}.
}
\examples{
library(dplyr)
library(nycflights13)

query <- "SELECT origin, dest,
    COUNT(flight) AS num_flts,
    round(AVG(distance)) AS dist,
    round(AVG(arr_delay)) AS avg_delay
  FROM flights
  WHERE distance BETWEEN 200 AND 300
    AND air_time IS NOT NULL
  GROUP BY origin, dest
  HAVING num_flts > 5000
  ORDER BY num_flts DESC, avg_delay DESC
  LIMIT 100;"

show_dplyr(query)
}
\seealso{
\code{\link{query}}
}
