#' Check the balance of presences vs pseudoabsences among splits
#'
#' @param splits the data splits (an `rset` object), generated by a function such as
#' [spatialsample::spatial_block_cv()]
#' @param .col the column containing the presences
#' @returns a table of number of presences and pseudoabsences
#' @export
#' @examples
#' lacerta_thin <- readRDS(system.file("extdata/lacerta_climate_sf.RDS",
#'   package = "tidysdm"
#' ))
#' lacerta_cv <- spatial_block_cv(lacerta_thin, v = 5)
#' check_splits_balance(lacerta_cv, class)
#'
check_splits_balance <- function(
    splits,
    .col) {
  .col <- rlang::enquo(.col) %>%
    rlang::quo_get_expr() %>%
    rlang::as_string()
  balance_list <- lapply(splits$splits, function(x) {
    table(rsample::training(x) %>%
      sf::st_drop_geometry() %>% dplyr::pull(.col))
  })
  balance_df <- do.call("rbind", balance_list)
  return(balance_df)
}
