% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdm_spec_gam.R
\name{sdm_spec_gam}
\alias{sdm_spec_gam}
\title{Model specification for a GAM for SDM}
\usage{
sdm_spec_gam(..., tune = "none")
}
\arguments{
\item{...}{parameters to be passed to \code{\link[parsnip:gen_additive_mod]{parsnip::gen_additive_mod()}} to
customise the model. See the help of that function for details.}

\item{tune}{character defining the tuning strategy. As there are no hyperparameters
to tune in a \emph{gam}, the only valid option is "none". This parameter is present
for consistency with other \verb{sdm_spec_*} functions, but it does nothing in this
case.}
}
\value{
a \link[parsnip:model_spec]{parsnip::model_spec} of the model.
}
\description{
This function returns a \link[parsnip:model_spec]{parsnip::model_spec} for a General Additive Model to
be used as a classifier of presences and absences in Species Distribution Model.
}
\examples{
my_gam_spec <- sdm_spec_gam()
}
\seealso{
Other "sdm model specifications": 
\code{\link{sdm_spec_boost_tree}()},
\code{\link{sdm_spec_glm}()},
\code{\link{sdm_spec_maxent}()},
\code{\link{sdm_spec_rand_forest}()}
}
\concept{"sdm model specifications"}
