% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyr_methods.R
\name{separate}
\alias{separate}
\title{Separate a character column into multiple columns with a regular
expression or numeric locations}
\usage{
separate(
  data,
  col,
  into,
  sep = "[^[:alnum:]]+",
  remove = TRUE,
  convert = FALSE,
  extra = "warn",
  fill = "warn",
  ...
)
}
\arguments{
\item{data}{A tidyseurat object}

\item{col}{Column name or position. This is passed to
  [tidyselect::vars_pull()].

  This argument is passed by expression and supports
  [quasiquotation][rlang::quasiquotation] (you can unquote column
  names or column positions).}

\item{into}{Names of new variables to create as character vector.
Use `NA` to omit the variable in the output.}

\item{sep}{Separator between columns.

  If character, `sep` is interpreted as a regular expression. The default
  value is a regular expression that matches any sequence of
  non-alphanumeric values.

  If numeric, `sep` is interpreted as character positions to split at. Positive
  values start at 1 at the far-left of the string; negative value start at -1 at
  the far-right of the string. The length of `sep` should be one less than
  `into`.}

\item{remove}{If `TRUE`, remove input column from output data frame.}

\item{convert}{If `TRUE`, will run [type.convert()] with
  `as.is = TRUE` on new columns. This is useful if the component
  columns are integer, numeric or logical.

  NB: this will cause string `"NA"`s to be converted to `NA`s.}

\item{extra}{If `sep` is a character vector, this controls what
  happens when there are too many pieces. There are three valid options:

  * "warn" (the default): emit a warning and drop extra values.
  * "drop": drop any extra values without a warning.
  * "merge": only splits at most `length(into)` times}

\item{fill}{If `sep` is a character vector, this controls what
  happens when there are not enough pieces. There are three valid options:

  * "warn" (the default): emit a warning and fill from the right
  * "right": fill with missing values on the right
  * "left": fill with missing values on the left}

\item{...}{Additional arguments passed on to methods.}
}
\value{
A tidyseurat objector a tibble depending on input
}
\description{
Given either a regular expression or a vector of character positions,
`separate()` turns a single character column into multiple columns.
}
\examples{

 un = pbmc_small \%>\% tidy \%>\% unite("new_col", c(orig.ident, groups)) 
 un \%>\% separate(col = new_col, into= c("orig.ident", "groups"))

}
\seealso{
[unite()], the complement, [extract()] which uses regular
  expression capturing groups.
}
