% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_methods.R
\name{select}
\alias{select}
\title{Subset columns using their names and types}
\usage{
select(.data, ...)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See *Methods*, below, for
more details.}

\item{...}{<[`tidy-select`][dplyr_tidy_select]> One or more unquoted
expressions separated by commas. Variable names can be used as if they
were positions in the data frame, so expressions like `x:y` can
be used to select a range of variables.}
}
\value{
An object of the same type as `.data`. The output has the following
properties:

* Rows are not affected.
* Output columns are a subset of input columns, potentially with a different
  order. Columns will be renamed if `new_name = old_name` form is used.
* Data frame attributes are preserved.
* Groups are maintained; you can't select off grouping variables.
}
\description{
Select (and optionally rename) variables in a data frame, using a concise
mini-language that makes it easy to refer to variables based on their name
(e.g. `a:f` selects all columns from `a` on the left to `f` on the
right). You can also use predicate functions like [is.numeric] to select
variables based on their properties.


## Overview of selection features

```{r, child = "man/rmd/overview.Rmd"}
```
}
\section{Methods}{

This function is a **generic**, which means that packages can provide
implementations (methods) for other classes. See the documentation of
individual methods for extra arguments and differences in behaviour.

The following methods are currently available in loaded packages:
\Sexpr[stage=render,results=rd]{dplyr:::methods_rd("select")}.
}

\examples{

`\%>\%` = magrittr::`\%>\%`
pbmc_small \%>\% tidy \%>\% select(cell, orig.ident )

}
\seealso{
Other single table verbs: 
\code{\link{arrange}()},
\code{\link{filter}()},
\code{\link{mutate}()},
\code{\link{rename}()},
\code{\link{slice}()},
\code{\link{summarise}()}
}
\concept{single table verbs}
