% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidysmd.R
\name{tidy_smd}
\alias{tidy_smd}
\title{Tidy Standardized Mean Differences}
\usage{
tidy_smd(
  .df,
  .vars,
  .group,
  .wts = NULL,
  include_unweighted = TRUE,
  na.rm = FALSE,
  gref = 1L,
  std.error = FALSE
)
}
\arguments{
\item{.df}{A data frame}

\item{.vars}{Variables for which to calculate SMD}

\item{.group}{Grouping variable}

\item{.wts}{Variables to use for weighting the SMD calculation}

\item{include_unweighted}{Logical. If using \code{.wts}, also calculate the
unweighted SMD?}

\item{na.rm}{Remove \code{NA} values from \code{x}? Defaults to \code{FALSE}.}

\item{gref}{an integer indicating which level of \code{g} to use as the reference
group. Defaults to \code{1}.}

\item{std.error}{Logical indicator for computing standard errors using
\code{\link[smd]{compute_smd_var}}. Defaults to \code{FALSE}.}
}
\value{
a tibble
}
\description{
\code{tidy_smd()} calculates the standardized mean difference (SMD) for variables
in a dataset between groups. Optionally, you may also calculate weighted
SMDs. \code{tidy_smd()} wraps \code{smd::smd()}, returning a tidy dataframe with the
columns \code{variable}, \code{weights}, and \code{smd}, as well as fourth column the
contains the level of \code{.group} the SMD represents. You may also supply
multiple weights to calculate multiple weighted SMDs, useful when comparing
different types of weights.
}
\examples{

tidy_smd(nhefs_weights, c(age, education, race), .group = qsmk)
tidy_smd(nhefs_weights, c(age, education), .group = qsmk, std.error = TRUE)

tidy_smd(
  nhefs_weights,
  c(age, race, education),
  .group = qsmk,
  .wts = c(w_ate, w_att, w_atm)
)
}
