% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util-methods.R
\name{sqextract}
\alias{sqextract}
\alias{sq-extract}
\title{Extract parts of a sq object}
\arguments{
\item{x}{[\code{sq}]\cr
An object this function is applied to.}

\item{i, j, ...}{[\code{numeric} || \code{logical}]\cr
Indices specifying elements to extract.}
}
\value{
\code{\link[=sq-class]{sq}} object of the same type as the input,
containing extracted elements
}
\description{
Operator to extract subsets of sq objects.
}
\details{
This function follows \code{\link[vctrs]{vctrs-package}} conventions
regarding argument interpretation for indexing vectors, which are a bit
stricter that normal R conventions, for example implicit argument recycling
is prohibited. Subsetting of the \code{sq} object does not affect its
attributes (class and alphabet of the object). Attempt to extract elements
using indices not present in the object will return an error.
}
\examples{
# Creating object to work on:
sq_unt <- sq(c("AHSNLVSCTK$SH\%&VS", "YQTVKA&#BSKJGY",
               "IAKVGDCTWCTY&GT", "AVYI#VSV&*DVGDJCFA"))

# Subsetting using numeric vectors
# Extracting second element of the object:
sq_unt[2]

# Extracting elements from second to fourth:
sq_unt[2:4]

# Extracting all elements except the third:
sq_unt[-3]

# Extracting first and third element:
sq_unt[c(1,3)]

# Subsetting using logical vectors
# Extracing first and third element:
sq_unt[c(TRUE, FALSE, TRUE, FALSE)]

# Subsetting using empty vector returns all values:
sq_unt[]

# Using NULL, on the other hand, returns empty sq:
sq_unt[NULL]

}
\seealso{
Functions from utility module:
\code{\link{==.sq}()},
\code{\link{get_sq_lengths}()},
\code{\link{is.sq}()},
\code{\link{sqconcatenate}}
}
\concept{util_functions}
