% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_stats.data.frame.r
\name{add_stats.data.frame}
\alias{add_stats.data.frame}
\title{add_stats data frame function}
\usage{
\method{add_stats}{data.frame}(output, results, identifier = NULL,
  statistics = NULL, type = NULL, confirmatory = NULL, notes = NULL)
}
\arguments{
\item{output}{A data frame that contains statistical output in a tidy format.}

\item{results}{A tidy stats list.}

\item{identifier}{A character string identifying the model. Automatically created if not provided.}

\item{statistics}{A vector of statistics to select from the output and add to the tidy stats list.}

\item{type}{A character string indicating the type of test. One of "hypothesis", "manipulation check", "contrast", "descriptives", or "other". Can be abbreviated.}

\item{confirmatory}{A boolean to indicate whether the statistical test was confirmatory (TRUE) or exploratory (FALSE). Can be NA.}

\item{notes}{A character string to add additional information. Some statistical tests produce notes information, which will be overwritten if notes are provided.}
}
\description{
\code{add_stats.data.frame} is a function to add a tidy data frame of results to a tidy stats list. tidystats does not support all possible statistical tests, so it may not be able to produce tidy output of a statistical model. The best solution for now is to tidy the output of a statistical test yourself, creating a tidy data frame, and then use \code{add_stats}, which will call this function, to add it to the tidy stats list.
}
\examples{

# Create an empty list to store the results in
results <- list()

# Example: Manual chi-squared test of independence
x_squared_data <- data.frame(
  statistic = c("X-squared", "df", "p"),
  value = c(5.4885, 6, 0.4828),
  method = "Chi-squared test of independence"
  )

# Add results to results
results <- add_stats(x_squared_data, results, identifier = "M1")

}
