% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_descriptives.r
\name{tidy_descriptives}
\alias{tidy_descriptives}
\title{Convert descriptives to a tidy data frame}
\usage{
tidy_descriptives(descriptives)
}
\arguments{
\item{descriptives}{A descriptives data frame}
}
\description{
\code{tidy_descriptives} returns a tidy data frame of descriptive statistics.
}
\examples{
library(magrittr)
library(dplyr)

# Get descriptives
descriptives <- describe(sleep, group)

# Create a tidy data frame of the descriptives
tidy_descriptives(descriptives)

# With a grouping variable:
sleep \%>\%
  group_by(group) \%>\%
  describe(extra) \%>\%
  tidy_descriptives()

}
