% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_stats.aovlist.R
\name{tidy_stats.aovlist}
\alias{tidy_stats.aovlist}
\title{Create a tidy stats data frame from an aovlist object}
\usage{
\method{tidy_stats}{aovlist}(model)
}
\arguments{
\item{model}{Output of \code{aov()} including within-subject factors.}
}
\description{
\code{tidy_stats.aovlist} takes an aovlist object and converts the object to
a tidy stats data frame.
}
\examples{
# Conduct a within-subjects ANOVA
model_aov_within <- aov(extra ~ group + Error(ID/group), data = sleep)

# Tidy stats
tidy_stats(model_aov_within)

}
