% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join.R
\name{anti_join.}
\alias{anti_join.}
\title{Join two data.tables together}
\usage{
anti_join.(x, y, by = NULL)
}
\arguments{
\item{x}{A data.frame or data.table}

\item{y}{A data.frame or data.table}

\item{by}{A character vector of variables to join by. If NULL, the default, the join will do a natural join, using all variables with common names across the two tables.}
}
\description{
Join two data.tables together
}
\examples{
df1 <- data.table(x = c("a", "a", "b", "c"), y = 1:4)
df2 <- data.table(x = c("a", "b"), z = 5:6)

df1 \%>\% left_join(df2)
df1 \%>\% inner_join(df2)
df1 \%>\% right_join(df2)
df1 \%>\% full_join(df2)
df1 \%>\% anti_join(df2)
}
\keyword{internal}
