% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_count.R
\name{add_tally.}
\alias{add_tally.}
\title{Add a count column to the data frame}
\usage{
add_tally.(.df, wt = NULL, sort = FALSE, name = NULL)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{wt}{Frequency weights.
Can be \code{NULL} or a variable:
\itemize{
\item If \code{NULL} (the default), counts the number of rows in each group.
\item If a variable, computes \code{sum(wt)} for each group.
}}

\item{sort}{If \code{TRUE}, will show the largest groups at the top.}

\item{name}{The name of the new column in the output.

If omitted, it will default to \code{n}.}
}
\description{
Add a count column to the data frame.

\code{df \%>\% add_count(a, b)} is equivalent to using \code{df \%>\% mutate(n = n(), .by = c(a, b))}
}
\examples{
df <- data.table(
  a = c("a", "a", "b"),
  b = 1:3
)

df \%>\%
  add_count(a)
}
\keyword{internal}
