% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distinct.R
\name{dt_distinct}
\alias{dt_distinct}
\title{Select distinct/unique rows}
\usage{
dt_distinct(.data, ...)
}
\arguments{
\item{.data}{A data.frame or data.table}

\item{...}{Columns to select before determining uniqueness. If omitted, will use all columns}
}
\description{
Retain only unique/distinct rows from an input df.

Supports enhanced selection if dots are used
}
\examples{
example_dt <- data.table::data.table(
  x = 1:3,
  y = 4:6,
  z = c("a", "a", "b"))

example_dt \%>\%
  dt_distinct()

example_dt \%>\%
  dt_distinct(z)
}
