% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_variants.R
\name{dt_rename_all}
\alias{dt_rename_all}
\alias{dt_rename_at}
\alias{dt_rename_across}
\alias{dt_rename_if}
\title{Rename a selection of variables}
\usage{
dt_rename_all(.data, .fun, ...)

dt_rename_at(.data, .vars, .fun, ...)

dt_rename_across(.data, .cols, .fun, ...)

dt_rename_if(.data, .predicate, .fun, ...)
}
\arguments{
\item{.data}{A data.frame or data.table}

\item{.fun}{Function to pass}

\item{...}{Other arguments for the passed function}

\item{.vars}{vector \code{c()} of bare column names for \code{dt_rename_at()} to use}

\item{.cols}{vector \code{c()} of bare column names for \code{dt_rename_across()} to use}

\item{.predicate}{Predicate to pass to \code{dt_rename_if()}}
}
\description{
These scoped variants of \code{rename()} operate on a selection of variables

There are two variants:
\itemize{
\item \code{dt_rename_all()}
\item \code{dt_rename_across()}: Replaces both \code{dt_rename_if()} & \code{dt_rename_at()}
}

Supports enhanced selection
}
\examples{
example_dt <- data.table::data.table(
  x = 1,
  y = 2,
  double_x = 2,
  double_y = 4)

as_dt(example_dt) \%>\% dt_rename_all(~ sub("x", "stuff", .x))

as_dt(example_dt) \%>\%
  dt_rename_across(c(x, double_x), ~ sub("x", "stuff", .x))
}
