% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice.R
\name{slice.}
\alias{slice.}
\alias{slice_head.}
\alias{slice_tail.}
\alias{slice_max.}
\alias{slice_min.}
\alias{slice_sample.}
\title{Choose rows in a data.table}
\usage{
slice.(.df, ..., .by = NULL)

slice_head.(.df, n = 5, .by = NULL)

slice_tail.(.df, n = 5, .by = NULL)

slice_max.(.df, order_by, n = 1, .by = NULL)

slice_min.(.df, order_by, n = 1, .by = NULL)

slice_sample.(.df, n, prop, weight_by = NULL, replace = FALSE, .by = NULL)
}
\arguments{
\item{.df}{A data.frame or data.table}

\item{...}{Integer row values}

\item{.by}{Columns to group by}

\item{n}{Number of rows to grab}

\item{order_by}{Variable to arrange by}

\item{prop}{The proportion of rows to select}

\item{weight_by}{Sampling weights}

\item{replace}{Should sampling be performed with (\code{TRUE}) or without (\code{FALSE}, default) replacement}
}
\description{
Choose rows in a data.table.
Grouped data.tables grab rows within each group.
}
\examples{
test_df <- data.table(
  x = c(1,2,3,4),
  y = c(4,5,6,7),
  z = c("a","a","a","b"))

test_df \%>\%
  slice.(1:3)

test_df \%>\%
  slice.(1, 3)

test_df \%>\%
  slice.(1, .by = z)

test_df \%>\%
  slice_head.(1, .by = z)

test_df \%>\%
  slice_tail.(1, .by = z)

test_df \%>\%
  slice_max.(order_by = x, .by = z)

test_df \%>\%
  slice_min.(order_by = y, .by = z)
}
