% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/case.R
\name{case}
\alias{case}
\title{data.table::fcase() with vectorized default}
\usage{
case(..., default = NA)
}
\arguments{
\item{...}{Sequence of condition/value designations}

\item{default}{Default value. Set to NA by default.}
}
\description{
This function allows you to use multiple if/else statements in one call.

It is called like \code{data.table::fcase()}, but allows the user to use
a vector as the \code{default} argument.
}
\examples{
df <- tidytable(x = 1:10)

df \%>\%
  mutate(case_x = case(x < 5, 1,
                         x < 7, 2,
                         default = 3))
}
