% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice.Spat.R
\name{slice}
\alias{slice}
\alias{slice.SpatRaster}
\alias{slice.SpatVector}
\alias{slice_head.SpatRaster}
\alias{slice_head.SpatVector}
\alias{slice_tail.SpatRaster}
\alias{slice_tail.SpatVector}
\alias{slice_min.SpatRaster}
\alias{slice_min.SpatVector}
\alias{slice_max.SpatRaster}
\alias{slice_max.SpatVector}
\alias{slice_sample.SpatRaster}
\alias{slice_sample.SpatVector}
\alias{slice_rows}
\alias{slice_rows.SpatRaster}
\alias{slice_cols}
\alias{slice_cols.SpatRaster}
\alias{slice_colrows}
\alias{slice_colrows.SpatRaster}
\title{Subset cells/rows/columns/geometries using their positions}
\usage{
\method{slice}{SpatRaster}(.data, ..., .preserve = FALSE, .keep_extent = FALSE)

\method{slice}{SpatVector}(.data, ..., .preserve = FALSE)

\method{slice_head}{SpatRaster}(.data, ..., n, prop, .keep_extent = FALSE)

\method{slice_head}{SpatVector}(.data, ..., n, prop)

\method{slice_tail}{SpatRaster}(.data, ..., n, prop, .keep_extent = FALSE)

\method{slice_tail}{SpatVector}(.data, ..., n, prop)

\method{slice_min}{SpatRaster}(
  .data,
  order_by,
  ...,
  n,
  prop,
  with_ties = TRUE,
  .keep_extent = FALSE
)

\method{slice_min}{SpatVector}(.data, order_by, ..., n, prop, with_ties = TRUE)

\method{slice_max}{SpatRaster}(
  .data,
  order_by,
  ...,
  n,
  prop,
  with_ties = TRUE,
  .keep_extent = FALSE
)

\method{slice_max}{SpatVector}(.data, order_by, ..., n, prop, with_ties = TRUE)

\method{slice_sample}{SpatRaster}(
  .data,
  ...,
  n,
  prop,
  weight_by = NULL,
  replace = FALSE,
  .keep_extent = FALSE
)

\method{slice_sample}{SpatVector}(.data, ..., n, prop, weight_by = NULL, replace = FALSE)

slice_rows(.data, ...)

\method{slice_rows}{SpatRaster}(.data, ..., .keep_extent = FALSE)

slice_cols(.data, ...)

\method{slice_cols}{SpatRaster}(.data, ..., .keep_extent = FALSE)

slice_colrows(.data, ...)

\method{slice_colrows}{SpatRaster}(.data, ..., cols, rows, .keep_extent = FALSE, inverse = FALSE)
}
\arguments{
\item{.data}{A SpatRaster created with \code{\link[terra:rast]{terra::rast()}} or a SpatVector
created with \code{\link[terra:vect]{terra::vect()}}.}

\item{...}{\code{\link[dplyr:slice]{data-masking}} Integer row values. Provide
either positive values to keep, or negative values to drop.

The values provided must be either all positive or all negative. Indices
beyond the number of rows in the input are silently ignored.
See \strong{Methods}.}

\item{.preserve}{Ignored for Spat* objects}

\item{.keep_extent}{Should the extent of the resulting SpatRaster be kept?
See also \code{\link[terra:trim]{terra::trim()}}, \code{\link[terra:extend]{terra::extend()}}.}

\item{n, prop}{Provide either \code{n}, the number of rows, or \code{prop}, the
proportion of rows to select. If neither are supplied, \code{n = 1} will be
used.

If a negative value of \code{n} or \code{prop} is provided, the specified number or
proportion of rows will be removed.

If \code{n} is greater than the number of rows in the group (or \code{prop > 1}),
the result will be silently truncated to the group size. If the
\code{prop}ortion of a group size does not yield an integer number of rows, the
absolute value of \code{prop*nrow(.data)} is rounded down.}

\item{order_by}{Variable or function of variables to order by.}

\item{with_ties}{Should ties be kept together? The default, \code{TRUE},
may return more rows than you request. Use \code{FALSE} to ignore ties,
and return the first \code{n} rows.}

\item{weight_by}{Sampling weights. This must evaluate to a vector of
non-negative numbers the same length as the input. Weights are
automatically standardised to sum to 1.}

\item{replace}{Should sampling be performed with (\code{TRUE}) or without
(\code{FALSE}, the default) replacement.}

\item{cols, rows}{Integer col/row values of the SpatRaster}

\item{inverse}{If \code{TRUE}, \code{.data} is inverse-masked to the given selection.
See \code{\link[terra:mask]{terra::mask()}}.}
}
\value{
A Spat* object  of the same class than \code{.data}. See \strong{Methods}.
}
\description{
\code{slice()} lets you index cells/rows/columns/geometries by their (integer)
locations. It allows you to select, remove, and duplicate those dimensions
of a Spat* object.

\strong{If you want to slice your SpatRaster by geographic coordinates} use
\code{\link[=filter.SpatRaster]{filter.SpatRaster()}} method.

It is accompanied by a number of helpers for common use cases:
\itemize{
\item \code{slice_head()} and \code{slice_tail()} select the first or last
cells/geometries.
\item \code{slice_sample()} randomly selects cells/geometries.
\item \code{slice_rows()} and \code{slice_cols()} allow to subset entire rows or columns,
of a SpatRaster.
\item \code{slice_colrows()} subsets regions of the raster by row and column position
of a SpatRaster.
}

You can get a skeleton of your SpatRaster with the cell, column and row
index with \code{\link[=as_coordinates]{as_coordinates()}}.

See \strong{Methods} for details.
}
\section{terra equivalent}{


\code{\link[terra:subset]{terra::subset()}}, \code{\link[terra:sample]{terra::spatSample()}}
}

\section{Methods}{


Implementation of the \strong{generic} \code{\link[dplyr:slice]{dplyr::slice()}} function.
\subsection{SpatRaster}{

The result is a SpatRaster with the crs and resolution of the input and
where cell values of the selected cells/columns/rows are preserved.

Use \code{.keep_extent = TRUE} to preserve the extent of \code{.data} on the output.
The non-selected cells would present a value of \code{NA}.
}

\subsection{SpatVector}{

This method relies on the implementation of \code{\link[dplyr:slice]{dplyr::slice()}} method on the
sf package. The result is a SpatVector where the attributes of the selected
geometries are preserved.
}
}

\examples{


library(terra)

f <- system.file("extdata/cyl_temp.tif", package = "tidyterra")
r <- rast(f)

# Slice first 100 cells
r \%>\%
  slice(1:100) \%>\%
  plot()

# Rows
r \%>\%
  slice_rows(1:30) \%>\%
  plot()

# Cols
r \%>\%
  slice_cols(-(20:50)) \%>\%
  plot()

# Spatial sample
r \%>\%
  slice_sample(prop = 0.2) \%>\%
  plot()


# Slice regions
r \%>\%
  slice_colrows(
    cols = c(20:40, 60:80),
    rows = -c(1:20, 30:50)
  ) \%>\%
  plot()
}
\seealso{
\code{\link[dplyr:slice]{dplyr::slice()}}, \code{\link[terra:sample]{terra::spatSample()}}.

You can get a skeleton of your SpatRaster with the cell, column and row
index with \code{\link[=as_coordinates]{as_coordinates()}}.

If you want to slice by geographic coordinates use \code{\link[=filter.SpatRaster]{filter.SpatRaster()}}.

Other dplyr methods:
\code{\link{filter}()},
\code{\link{mutate}()},
\code{\link{pull}()},
\code{\link{relocate}()},
\code{\link{rename}()},
\code{\link{select}()}

Other single table verbs: 
\code{\link{filter}()},
\code{\link{mutate}()},
\code{\link{rename}()},
\code{\link{select}()}
}
\concept{dplyr.methods}
\concept{single table verbs}
