% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales_fill_terrain.R
\name{scale_fill_terrain}
\alias{scale_fill_terrain}
\alias{scale_fill_terrain_d}
\alias{scale_fill_terrain_c}
\alias{scale_fill_terrain_b}
\title{Terrain colour fill scales from grDevices}
\usage{
scale_fill_terrain_d(..., alpha = 1, direction = 1)

scale_fill_terrain_c(
  ...,
  alpha = 1,
  direction = 1,
  na.value = NA,
  guide = "colourbar"
)

scale_fill_terrain_b(
  ...,
  alpha = 1,
  direction = 1,
  na.value = NA,
  guide = "coloursteps"
)
}
\arguments{
\item{...}{Other arguments passed on to \code{\link[ggplot2:discrete_scale]{discrete_scale()}},
\code{\link[ggplot2:continuous_scale]{continuous_scale()}}, or \link[ggplot2]{binned_scale} to control name, limits, breaks,
labels and so forth.}

\item{alpha}{The alpha transparency, a number in [0,1], see argument alpha in
\code{\link[grDevices]{hsv}}.}

\item{direction}{Sets the order of colors in the scale. If 1, the default, colors
are ordered from darkest to lightest. If -1, the order of colors is reversed.}

\item{na.value}{Missing values will be replaced with this value.}

\item{guide}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}
}
\value{
The corresponding ggplot2 layer with the values applied to the
\code{fill} aesthetics.
}
\description{
Implementation of the classic color palettes used by default by the
terra package (see \code{\link[terra:plot]{terra::plot()}}). Three fill scales are provided:
\itemize{
\item \code{scale_fill_terrain_d()}: For discrete values.
\item \code{scale_fill_terrain_c()}: For continuous values.
\item \code{scale_fill_terrain_b()}: For binning continuous values.
}
}
\examples{
\donttest{
filepath <- system.file("extdata/volcano2.tif", package = "tidyterra")

library(terra)
volcano2_rast <- rast(filepath)

library(ggplot2)
ggplot() +
  geom_spatraster(data = volcano2_rast) +
  scale_fill_terrain_c()

# Binned
ggplot() +
  geom_spatraster(data = volcano2_rast) +
  scale_fill_terrain_b(breaks = seq(70, 200, 10))

# With discrete values
factor <- volcano2_rast \%>\% mutate(cats = cut(elevation,
  breaks = c(100, 120, 130, 150, 170, 200),
  labels = c(
    "Very Low", "Low", "Average", "High",
    "Very High"
  )
))


ggplot() +
  geom_spatraster(data = factor, aes(fill = cats)) +
  scale_fill_terrain_d(na.value = "gray10")
}
}
\seealso{
\code{\link[terra:plot]{terra::plot()}}, \code{\link[ggplot2:scale_viridis]{ggplot2::scale_fill_viridis_c()}}

Other gradient scales and palettes for hypsometry:
\code{\link{scale_fill_cross_blended}},
\code{\link{scale_fill_hypso}},
\code{\link{scale_fill_whitebox}},
\code{\link{scale_fill_wiki}}
}
\concept{gradients}
