% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_tf_idf.R, R/sparse_casters.R,
%   R/tidytext.R, R/unnest_tokens.R
\name{bind_tf_idf_}
\alias{bind_tf_idf_}
\alias{cast_sparse_}
\alias{cast_tdm_}
\alias{cast_dtm_}
\alias{cast_dfm_}
\alias{deprecated-se}
\alias{unnest_tokens_}
\title{Deprecated SE version of functions}
\usage{
bind_tf_idf_(tbl, term, document, n)

cast_sparse_(data, row, column, value)

cast_tdm_(data, term, document, value, weighting = tm::weightTf, ...)

cast_dtm_(data, document, term, value, weighting = tm::weightTf, ...)

cast_dfm_(data, document, term, value, ...)

unnest_tokens_(tbl, output, input, token = "words", format = c("text",
  "man", "latex", "html", "xml"), to_lower = TRUE, drop = TRUE,
  collapse = NULL, ...)
}
\arguments{
\item{tbl}{A data frame.}

\item{term, document, n}{Strings giving names of term, document, and count columns.}

\item{data}{A tbl}

\item{row}{Column name to use as row names in sparse matrix, as string or symbol}

\item{column}{Column name to use as column names in sparse matrix, as string or symbol}

\item{value}{Column name to use as sparse matrix values (default 1) as string or symbol}

\item{weighting}{The weighting function for the DTM/TDM
(default is term-frequency, effectively unweighted)}

\item{...}{Extra arguments to pass on to \code{\link{sparseMatrix}}}

\item{output, input}{Name of columns.}

\item{token}{Unit for tokenizing, or a custom tokenizing function. Built-in
options are "words" (default), "characters", "character_shingles", "ngrams",
"skip_ngrams", "sentences", "lines", "paragraphs", "regex", "tweets"
(tokenization by word that preserves usernames, hashtags, and URLS ), and
"ptb" (Penn Treebank). If a function, should take a character vector and
return a list of character vectors of the same length.}

\item{format}{Either "text", "man", "latex", "html", or "xml". If not text,
this uses the hunspell tokenizer, and can tokenize only by "word"}

\item{to_lower}{Whether to convert tokens to lowercase. If tokens include
URLS (such as with \code{token = "tweets"}), such converted URLs may no
longer be correct.}

\item{drop}{Whether original input column should get dropped. Ignored
if the original input and new output column have the same name.}

\item{collapse}{Whether to combine text with newlines first in case tokens
(such as sentences or paragraphs) span multiple lines. If NULL, collapses
when token method is "ngrams", "skip_ngrams", "sentences", "lines",
"paragraphs", or "regex".}

\item{output_col, input_col}{Strings giving names of output and input columns.}
}
\description{
tidytext used to offer twin versions of each verb suffixed with an
underscore, like dplyr and the main tidyverse packages. These
versions had standard evaluation (SE) semantics; rather than taking
arguments by code, like NSE verbs, they took arguments by value.
Their purpose was to make it possible to program with tidytext.
However, tidytext now uses tidy evaluation semantics. NSE verbs
still capture their arguments, but you can now unquote parts of
these arguments. This offers full programmability with NSE verbs.
Thus, the underscored versions are now superfluous.
}
\details{
Unquoting triggers immediate evaluation of its operand and inlines
the result within the captured expression. This result can be a
value or an expression to be evaluated later with the rest of the
argument.
}
\keyword{internal}
