% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_feed_by_area}
\alias{filter_feed_by_area}
\title{Filter a gtfs feed so that it only contains trips that pass a given area}
\usage{
filter_feed_by_area(gtfs_obj, area)
}
\arguments{
\item{gtfs_obj}{gtfs feed (tidygtfs object)}

\item{area}{all trips passing through this area are kept. Either a bounding box
(numeric vector with xmin, ymin, xmax, ymax) or a sf object.}
}
\value{
tidygtfs object with filtered tables
}
\description{
Only stop_times, stops, routes, services (in calendar and calendar_dates), shapes,
frequencies and transfers belonging to one of those trips are kept.
}
\seealso{
\code{\link{filter_feed_by_stops}}, \code{\link{filter_feed_by_trips}}, \code{\link{filter_feed_by_date}}
}
