% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy-posterior-BART.R
\name{predicted_draws_BART}
\alias{predicted_draws_BART}
\title{Get predict draws from posterior of \code{BART}-package models}
\usage{
predicted_draws_BART(
  model,
  newdata = NULL,
  prediction = ".prediction",
  rng = stats::rnorm,
  include_newdata = TRUE,
  include_fitted = FALSE,
  include_sigsqs = FALSE
)
}
\arguments{
\item{model}{A \code{BART}-package model.}

\item{newdata}{Data frame to generate predictions from. If omitted, most model types will generate predictions from the data used to fit the model.}

\item{prediction}{The name of the output column for \code{predicted_draws}; default \code{".prediction"}.}

\item{rng}{Random number generator function. Default is \code{rnorm} for models with Gaussian errors.}

\item{include_newdata}{Should the newdata be included in the tibble?}

\item{include_fitted}{Should the posterior fitted values be included in the tibble?}

\item{include_sigsqs}{Should the posterior sigma-squared draw be included?}
}
\value{
A tidy data frame (tibble) with predicted values.
}
\description{
Get predict draws from posterior of \code{BART}-package models
}
