% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpcstats.R
\name{stratify}
\alias{stratify}
\alias{stratify.tidyvpcobj}
\title{Stratification for Visual Predictive Check (VPC)}
\usage{
stratify(o, ...)

\method{stratify}{tidyvpcobj}(o, formula, data = o$data, ...)
}
\arguments{
\item{o}{A \code{tidyvpcobj}.}

\item{...}{Other arguments to include.}

\item{formula}{Formula for stratification.}

\item{data}{Observed data supplied in \code{observed()} function.}
}
\value{
Returns updated \code{tidyvpcobj} with stratification formula, stratification column(s), and strat.split datasets, which
  is \code{obs} split by unique levels of stratification variable(s). Resulting datasets are of class object \code{data.frame}
  and \code{data.table}.
}
\description{
Use to specify stratification variables for VPC.
}
\examples{
require(magrittr)

vpc <- observed(obs_data, x=TIME, y=DV) \%>\%
    simulated(sim_data, y=DV) \%>\%
    stratify(~ GENDER) \%>\%
    binning(NTIME) \%>\%
    vpcstats()

# Example with 2-way stratification by GENDER and STUDY.

vpc <- vpc \%>\%
    stratify(~ GENDER + STUDY) \%>\%
    binning(bin = "centers", centers = c(1,3,5,7,10)) \%>\%
    vpcstats()

}
\seealso{
\code{\link{observed}} \code{\link{simulated}} \code{\link{censoring}} \code{\link{predcorrect}} \code{\link{binning}} \code{\link{binless}} \code{\link{vpcstats}}
}
