% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_get_qualifiers.R
\name{tw_get_qualifiers}
\alias{tw_get_qualifiers}
\title{Get Wikidata qualifiers for a given property of a given item}
\usage{
tw_get_qualifiers(
  id,
  p,
  language = "all_available",
  cache = NULL,
  overwrite_cache = FALSE,
  wait = 0,
  include_id_and_p = TRUE
)
}
\arguments{
\item{id}{A characther vector of length 1, must start with Q, e.g. "Q254" for Wolfgang Amadeus Mozart.}

\item{p}{A character vector of length 1, a property. Must always start with the capital letter "P", e.g. "P31" for "instance of".}

\item{language}{Defaults to "all_available". It should be relevant only for caching purposes. For a full list of available values, see: https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}

\item{cache}{Defaults to NULL. If given, it should be given either TRUE or FALSE. Typically set with \code{tw_enable_cache()} or \code{tw_disable_cache()}.}

\item{overwrite_cache}{Logical, defaults to FALSE. If TRUE, it overwrites the table in the local sqlite database. Useful if the original Wikidata object has been updated.}

\item{wait}{In seconds, defaults to 0. Time to wait between queries to Wikidata. If data are cached locally, wait time is not applied. If you are running many queries systematically you may want to add some waiting time between queries.}

\item{include_id_and_p}{Logical, defaults to TRUE If TRUE, output includes a column with the wikidata id of the item.}
}
\value{
A data frame (a tibble) with five columns: \code{id} for the input id, \code{qualifier_id}, \code{property}, \code{value}, and \code{set} (to distinguish sets of data when a property is present more than once)
}
\description{
N.B. In order to provide for consistently structured output, this function outputs either id or value for each  qualifier. The user should keep in mind that some of these come with additional detail (e.g. the unit, precision, or reference calendar).
}
\examples{
tw_get_qualifiers(id = "Q180099", p = "P26", language = "en")
}
