% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_search.R
\name{tw_search}
\alias{tw_search}
\title{Search for Wikidata items or properties and return Wikidata id, label, and description.}
\usage{
tw_search(
  search,
  type = "item",
  language = "en",
  limit = 10,
  wait = 0,
  cache = NULL,
  overwrite_cache = FALSE
)
}
\arguments{
\item{search}{A string to be searched in Wikidata}

\item{type}{Defaults to "item". Either "item" or "property".}

\item{language}{Language to be used for the search. For a full list, see https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}

\item{limit}{Maximum numbers of responses to be given.}

\item{wait}{In seconds, defaults to 0. Time to wait between queries to Wikidata. If data are cached locally, wait time is not applied. If you are running many queries systematically you may want to add some waiting time between queries.}

\item{cache}{Defaults to NULL. If given, it should be given either TRUE or FALSE. Typically set with \code{tw_enable_cache()} or \code{tw_disable_cache()}.}

\item{overwrite_cache}{Defaults to FALSE. If TRUE, overwrites cache.}
}
\value{
A data frame (a tibble) with three columns (id, label, and description), and as many rows as there are results (by default, limited to 10).
}
\description{
This search returns only items, use \code{tw_search_property()} for properties.
}
\examples{
tw_search(search = "Sylvia Pankhurst")
}
