#' @title The Death Penalty and Race
#' 
#' @description A dataset recreated from summary data that describes relationships between race of defendant, race of victim,
#' and outcome of trial in a number of capital cases in Florida in 1976-1977.  The variables are as follows:
#' 
#' \itemize{
#'   \item defrace. Race of the defendant in the capital case.  
#'   \item vicrace. Race of the victim.
#'   \item death.  Whether or not the defendant in the case received the death penalty.
#' }
#' 
#' @docType data
#' @keywords datasets
#' @source Michael J. Radelet:  "Racial Characteristics and the Imposition of the Death Penalty",
#' \emph{American Sociological Review}, 46 (1981).
#' See also the JSTOR location:  \url{http://goo.gl/ECLVa}.
#' @format A data frame with 326 rows and 3 variables
#' @name deathpen
NULL