% Generated by roxygen2 (4.0.2): do not edit by hand
\name{barchartGC}
\alias{barchartGC}
\title{Easy Barcharts}
\usage{
barchartGC(x,data=parent.frame(),type="frequency",flat=FALSE,auto.key=TRUE,
                       horizontal=FALSE,stack=FALSE,...)
}
\arguments{
\item{x}{Either a formula or an object that can be coerced to a table.  If formula, it must be
of the form ~var or ~var1+var2.}

\item{data}{Usually a data frame that supplies the variables in \code{x}.  Variables not in the data
argument are searched for in the parent environment.}

\item{type}{Possible values are "frequency" and "percent".}

\item{flat}{If set to TRUE, will produce barchart that resembles the layout of \code{xtabs}}

\item{auto.key}{Provides a simple key}

\item{horizontal}{Determines orientation of the bars (overrriden by flat)}

\item{stack}{Determines whether bars for tallies are stacked on eac other or placed
next to one another (overrriden by flat)}

\item{...}{other arguments passed to \code{barchart}:  these include main, sub, and
xlab, which are likely to be familiar to students from other \code{lattice} graphical
functions.  An error is possible if other arguments
pertaining to legends are passed (hopefully anyone interested in such will have moved on
to \code{barchart}).}
}
\value{
A trellis object describing the barchart.
}
\description{
Wrapper for \code{\link{barchart}} in package \code{lattice}.  Creates a
barchart from raw data using formula-data syntax similar to that of \code{\link{xtabs}},
or from a table.  Defaults to a "standard"
barchart in which the bars are vertical and unstacked.  Supports percentage barcharts.
}
\examples{
#barchart of counts for one factor variable:
barchartGC(~sex,data=m111survey)

#barchart with percentages and title:
barchartGC(~sex,data=m111survey,
   type="percent",
   main="Distribution of Sex")

#barchart of counts, to study the relationship between
#two factor variables:
barchartGC(~sex+seat,data=m111survey)

#percentage barchart, two factor variables:
barchartGC(~sex+seat,data=m111survey,type="percent")

#From tabulated data:
sexseat <- xtabs(~sex+seat,data=m111survey)
barchartGC(sexseat,type="percent",main="Sex and Seating Preference")

#from tabulated data:
dieTosses <- c(one=8,two=18,three=11,four=7,five=9,six=7)
barchartGC(dieTosses,main="60 Rolls of a Die")

# a "flat" barchart, pictorial version of xtabs()
barchartGC(~sex+seat,data=m111survey,flat=TRUE,ylab="Sex")

# a "flat" barchart, pictorial version of xtabs()
barchartGC(~sex+seat,data=m111survey,type="percent",flat=TRUE,ylab="Sex")
}
\author{
Homer White \email{hwhite0@georgetowncollege.edu}
}

