% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-time_series_boxplot.R
\name{plot_time_series_boxplot}
\alias{plot_time_series_boxplot}
\title{Interactive Time Series Box Plots}
\usage{
plot_time_series_boxplot(
  .data,
  .date_var,
  .value,
  .period,
  .color_var = NULL,
  .facet_vars = NULL,
  .facet_ncol = 1,
  .facet_nrow = 1,
  .facet_scales = "free_y",
  .facet_dir = "h",
  .facet_collapse = FALSE,
  .facet_collapse_sep = " ",
  .facet_strip_remove = FALSE,
  .line_color = "#2c3e50",
  .line_size = 0.5,
  .line_type = 1,
  .line_alpha = 1,
  .y_intercept = NULL,
  .y_intercept_color = "#2c3e50",
  .smooth = TRUE,
  .smooth_func = ~mean(.x, na.rm = TRUE),
  .smooth_period = "auto",
  .smooth_message = FALSE,
  .smooth_span = NULL,
  .smooth_degree = 2,
  .smooth_color = "#3366FF",
  .smooth_size = 1,
  .smooth_alpha = 1,
  .legend_show = TRUE,
  .title = "Time Series Plot",
  .x_lab = "",
  .y_lab = "",
  .color_lab = "Legend",
  .interactive = TRUE,
  .plotly_slider = FALSE,
  .trelliscope = FALSE
)
}
\arguments{
\item{.data}{A \code{tibble} or \code{data.frame} with a time-based column}

\item{.date_var}{A column containing either date or date-time values}

\item{.value}{A column containing numeric values}

\item{.period}{A time series unit of aggregation for the boxplot. Examples include:
\itemize{
\item "1 week"
\item "3 years"
\item "30 minutes"
}}

\item{.color_var}{A categorical column that can be used to change the
line color}

\item{.facet_vars}{One or more grouping columns that broken out into \code{ggplot2} facets.
These can be selected using \code{tidyselect()} helpers (e.g \code{contains()}).}

\item{.facet_ncol}{Number of facet columns.}

\item{.facet_nrow}{Number of facet rows (only used for \code{.trelliscope = TRUE})}

\item{.facet_scales}{Control facet x & y-axis ranges.
Options include "fixed", "free", "free_y", "free_x"}

\item{.facet_dir}{The direction of faceting ("h" for horizontal, "v" for vertical). Default is "h".}

\item{.facet_collapse}{Multiple facets included on one facet strip instead of
multiple facet strips.}

\item{.facet_collapse_sep}{The separator used for collapsing facets.}

\item{.facet_strip_remove}{Whether or not to remove the strip and text label for each facet.}

\item{.line_color}{Line color. Overrided if \code{.color_var} is specified.}

\item{.line_size}{Line size.}

\item{.line_type}{Line type.}

\item{.line_alpha}{Line alpha (opacity). Range: (0, 1).}

\item{.y_intercept}{Value for a y-intercept on the plot}

\item{.y_intercept_color}{Color for the y-intercept}

\item{.smooth}{Logical - Whether or not to include a trendline smoother.
Uses See \code{\link[=smooth_vec]{smooth_vec()}} to apply a LOESS smoother.}

\item{.smooth_func}{Defines how to aggregate the .value to show the smoothed trendline.
The default is \code{~ mean(.x, na.rm = TRUE)}, which uses lambda function to ensure \code{NA} values are removed.
Possible values are:
\itemize{
\item A function, e.g. \code{mean}.
\item A purrr-style lambda, e.g. \code{~ mean(.x, na.rm = TRUE)}
}}

\item{.smooth_period}{Number of observations to include in the Loess Smoother.
Set to "auto" by default, which uses \code{tk_get_trend()}
to determine a logical trend cycle.}

\item{.smooth_message}{Logical.
Whether or not to return the trend selected as a message.
Useful for those that want to see what \code{.smooth_period} was selected.}

\item{.smooth_span}{Percentage of observations to include in the Loess Smoother.
You can use either period or span. See \code{\link[=smooth_vec]{smooth_vec()}}.}

\item{.smooth_degree}{Flexibility of Loess Polynomial.
Either 0, 1, 2 (0 = lest flexible, 2 = more flexible).}

\item{.smooth_color}{Smoother line color}

\item{.smooth_size}{Smoother line size}

\item{.smooth_alpha}{Smoother alpha (opacity). Range: (0, 1).}

\item{.legend_show}{Toggles on/off the Legend}

\item{.title}{Title for the plot}

\item{.x_lab}{X-axis label for the plot}

\item{.y_lab}{Y-axis label for the plot}

\item{.color_lab}{Legend label if a \code{color_var} is used.}

\item{.interactive}{Returns either a static (\code{ggplot2}) visualization or an interactive (\code{plotly}) visualization}

\item{.plotly_slider}{If TRUE, returns a plotly date range slider.}

\item{.trelliscope}{Returns either a normal plot or a trelliscopejs plot (great for many time series)
Must have \code{trelliscopejs} installed.}
}
\value{
A static \code{ggplot2} plot or an interactive \code{plotly} plot
}
\description{
A boxplot function that generates interactive \code{plotly} plots
for time series.
}
\details{
\code{plot_time_series_boxplot()} is a scalable function that works with both \emph{ungrouped} and \emph{grouped}
\code{data.frame} objects (and \code{tibbles}!).

\strong{Interactive by Default}

\code{plot_time_series_boxplot()} is built for exploration using:
\itemize{
\item \strong{Interactive Plots:} \code{plotly} (default) - Great for exploring!
\item \strong{Static Plots:} \code{ggplot2} (set \code{.interactive = FALSE}) - Great for PDF Reports
}

By default, an interactive \code{plotly} visualization is returned.

\strong{Scalable with Facets & Dplyr Groups}

\code{plot_time_series_boxplot()} returns multiple time series plots using \code{ggplot2} facets:
\itemize{
\item \code{group_by()} - If groups are detected, multiple facets are returned
\item \code{plot_time_series_boxplot(.facet_vars)} - You can manually supply facets as well.
}

\strong{Can Transform Values just like ggplot}

The \code{.values} argument accepts transformations just like \code{ggplot2}.
For example, if you want to take the log of sales you can use
a call like \code{plot_time_series_boxplot(date, log(sales))} and the log transformation
will be applied.

\strong{Smoother Period / Span Calculation}

The \code{.smooth = TRUE} option returns a smoother that is calculated based on either:
\enumerate{
\item A \code{.smooth_func}: The method of aggregation.
Usually an aggregation like \code{mean} is used.
The \code{purrr}-style function syntax can be used to apply complex functions.
\item A \code{.smooth_period}: Number of observations
\item A \code{.smooth_span}: A percentage of observations
}

By default, the \code{.smooth_period} is automatically calculated using 75\% of the observertions.
This is the same as \code{geom_smooth(method = "loess", span = 0.75)}.

A user can specify a time-based window (e.g. \code{.smooth_period = "1 year"})
or a numeric value (e.g. \code{smooth_period = 365}).

Time-based windows return the median number of observations in a window using \code{tk_get_trend()}.
}
\examples{

library(tidyverse)
library(tidyquant)
library(lubridate)
library(timetk)

# Works with individual time series
FANG \%>\%
    filter(symbol == "FB") \%>\%
    plot_time_series_boxplot(
        date, adjusted,
        .period      = "3 month",
        .interactive = FALSE)

# Works with groups
FANG \%>\%
    group_by(symbol) \%>\%
    plot_time_series_boxplot(
        date, adjusted,
        .period      = "3 months",
        .facet_ncol  = 2,     # 2-column layout
        .interactive = FALSE)

\dontrun{
# Can also group inside & use .color_var
FANG \%>\%
    mutate(year = year(date)) \%>\%
    plot_time_series_boxplot(
        date, adjusted,
        .period      = "3 months",
        .facet_vars   = c(symbol, year), # add groups/facets
        .color_var    = year,            # color by year
        .facet_ncol   = 4,
        .facet_scales = "free",
        .interactive  = FALSE)
}

# Can apply transformations to .value or .color_var
# - .value = log(adjusted)
# - .color_var = year(date)
FANG \%>\%
    plot_time_series_boxplot(
        date, log(adjusted),
        .period      = "3 months",
        .color_var    = year(date),
        .facet_vars   = contains("symbol"),
        .facet_ncol   = 2,
        .facet_scales = "free",
        .y_lab        = "Log Scale",
        .interactive  = FALSE)

# Can adjust the smoother
FANG \%>\%
    group_by(symbol) \%>\%
    plot_time_series_boxplot(
        date, adjusted,
        .period           = "3 months",
        .smooth           = TRUE,
        .smooth_func      = median,    # Smoother function
        .smooth_period    = "5 years", # Smoother Period
        .facet_ncol       = 2,
        .interactive      = FALSE)

}
