% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tzone.R
\name{as.tzone}
\alias{as.tzone}
\alias{as.tzone.tind}
\alias{as.tzone.POSIXct}
\alias{as.tzone.POSIXlt}
\alias{as.tzone.tinterval}
\title{Get the Same Date and Time in a Different Time Zone}
\usage{
as.tzone(x, tz)

\method{as.tzone}{tind}(x, tz)

\method{as.tzone}{POSIXct}(x, tz)

\method{as.tzone}{POSIXlt}(x, tz)

\method{as.tzone}{tinterval}(x, tz)
}
\arguments{
\item{x}{an object of \code{tind} class or of \code{POSIXct}/\code{POSIXlt}
classes (or of other class for which the method was implemented).}

\item{tz}{a character value determining the new time zone.
See \code{\link{tzone}} documentation for information on time zones.}
}
\value{
An object of the same class and length as \code{x} with adjusted
underlying date-time representation and time zone set to \code{tz}.
}
\description{
This method allows to determine time index representing the same date and
time in a different time zone.
}
\details{
The underlying time (as measured by number of seconds since the Unix epoch in UTC)
will change so that the date-time components in the new and old time zones
are the same. For \code{tind} arguments, if (due to DST time changes or UTC
offset changes) date-time indices do not occur in the new time zone,
\code{NA}s are introduced with a warning. For \code{tinterval} arguments, the result
is adjusted with a warning, in order not to create open-ended time intervals.

The method is implemented for objects of \code{tind} class of type \code{"t"}
(date-time), objects of \code{tinterval} class of type \code{"t"} (time intervals),
as well as base \code{POSIXct} and \code{POSIXlt} classes.

List of time zones supported by the particular R installation can be obtained
via a call to \code{\link[base]{OlsonNames}} function.
}
\examples{
if (all(c("Europe/Warsaw", "America/New_York") \%in\% OlsonNames())) {
# check time in one time zone
print(nw <- now(tz = "Europe/Warsaw"))
# the same date-time in a new time zone
print(nw2 <- as.tzone(nw, "America/New_York"))
# note the time difference (equal to the difference of UTC offsets)
# warning on different time zones will be issued
print(suppressWarnings(nw2 - nw))
try(nw2 - nw)
}

}
\seealso{
\code{\link{tzone}} method and \code{\link{date_time}} for construction
od date-time indices from its components.
}
