% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type_vline.R
\name{type_vline}
\alias{type_vline}
\title{Trace a vertical line on the plot}
\usage{
type_vline(v = 0)
}
\arguments{
\item{v}{x-value(s) for vertical line(s). Numeric of length 1 or equal to the number of facets.}
}
\description{
Trace a vertical line on the plot
}
\examples{
tinyplot(mpg ~ hp, data = mtcars)
tinyplot_add(type = type_vline(150))

# facet-specify location and colors
cols = c("black", "green", "orange")
tinyplot(mpg ~ hp | factor(cyl), facet = ~ factor(cyl), data = mtcars, col = cols)
tinyplot_add(type = type_vline(v = c(100, 150, 200)), lty = 3, lwd = 3)

}
