% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tinyAxis.R
\name{tinyAxis}
\alias{tinyAxis}
\title{Generic function for adding an axis to a (tiny)plot}
\usage{
tinyAxis(x = NULL, ..., type = "standard", labeller = NULL)
}
\arguments{
\item{x}{an object which indicates the range over which an axis should
    be drawn}

\item{...}{arguments to be passed to methods and perhaps then to
    \code{\link[graphics]{axis}}.}

\item{type}{the type of axis to be drawn; inherited from the \code{xaxt} or \code{yaxt}
arguments of the parent \code{\link[=tinyplot]{tinyplot()}} call. One of either: \code{"standard"}
(default that draws the axis, ticks, and labels), \code{"none"} (no axes),
\code{"ticks"} (only ticks and labels without axis line), \code{"labels"} (only
labels without ticks and axis line), or \code{"axis"} (only axis line and labels
but no ticks). Partial matching is allowed, e.g. \code{type = "s"}.}

\item{labeller}{a formatting function to be applied to \code{x}, e.g. \code{\link{format}},
\code{\link{toupper}}, \code{\link{abs}}, or other custom function (including from the popular
\strong{scales} package). Can also be one of the following convenience strings
(symbols), for which common formatting transformations are provided:
\code{"percent"} (\code{"\%"}), \code{"comma"} (\code{","}), \code{"log"} (\code{"l"}), \code{"dollar"}
(\code{"$"}), \code{"euro"} (\code{"€"}), or \code{"sterling"} (\code{"£"}).}
}
\description{
Internal function used for adding an axis to a \code{\link{tinyplot}}
call.
}
\details{
\code{tinyAxis} provides a thin(ish) wrapper around
\code{\link[graphics]{Axis}}, but with enhanced flexibility to (i) match
parameter combinations based on the axis type and plotting theme, (ii)
provide better support for date-time variables, and (iii) enable convenient
formatting of axis tick labels.
}
\examples{
\dontrun{

# plot without axes
tinyplot(0:10, axes = "n")
# add x-axis (labels only)
tinyplot:::tinyAxis(x = 0:10, side = 1, type = "l")
# add y-axis (with custom label formatting)
tinyplot:::tinyAxis(x = 0:10, side = 2, type = "s", labeller = "$")
}
}
\keyword{internal}
