% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect_snapshot_plot.R
\name{expect_snapshot_plot}
\alias{expect_snapshot_plot}
\title{Test if the new plot matches a target (snapshot) plot}
\usage{
expect_snapshot_plot(
  current,
  label,
  width = getOption("tinysnapshot_width", default = NULL),
  height = getOption("tinysnapshot_height", default = NULL),
  tol = getOption("tinysnapshot_tol", default = 0),
  metric = getOption("tinysnapshot_metric", default = "AE"),
  fuzz = getOption("tinysnapshot_fuzz", default = 0),
  device = getOption("tinysnapshot_device", default = "svg")
)
}
\arguments{
\item{current}{an object of class \code{ggplot} or a function which returns a base R plot.}

\item{label}{a string to identify the snapshot (alpha-numeric, hyphens, or underscores). Each plot in the test suite must have a unique label.}

\item{width}{of the snapshot. PNG default: 480 pixels. SVG default: 7 inches.}

\item{height}{of the snapshot. PNG default: 480 pixels. SVG default: 7 inches.}

\item{tol}{distance estimates larger than this threshold will trigger a test failure. Scale depends on the \code{metric} argument. With the default \code{metric="AE"} (absolute error), the \code{tolerance} corresponds roughly to the number of pixels of difference between the plot and the reference image.}

\item{metric}{string with a metric from \code{magick::metric_types()} such as \code{"AE"} or \code{"phash"}.}

\item{fuzz}{relative color distance between 0 and 100 to be considered similar.}

\item{device}{"svg", "png", "ragg" or "svglite"}
}
\value{
A \code{tinytest} object. A \code{tinytest} object is a \code{logical} with attributes holding information about the test that was run
}
\description{
This expectation can be used with \code{tinytest} to check if the new plot matches
a target plot.

When the expectation is checked for the first time, the expectation fails and
a reference plot is saved to the \verb{inst/tinytest/_tinysnapshot} folder.

When the expectation fails, the reference plot, the new plot, and a diff are
saved to the \code{inst/tinytest/label} folder. Call the \code{review()} function to compare.

To update a snapshot, delete the reference file from the \verb{_tinysnapshot}
folder and run the test suite again.

See the package README file or website for detailed examples.
}
