% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createStochasticWeightPosterior.R
\name{createStochasticWeightPosterior}
\alias{createStochasticWeightPosterior}
\title{Average over multiple posteriors created using different informative component weights.}
\usage{
createStochasticWeightPosterior(
  mapPrior,
  newTrialData,
  weights,
  nullTreatmentEffect = 0,
  sigma,
  mceErrorMargin = 0.05
)
}
\arguments{
\item{mapPrior}{The MAP prior to be robustified, created using \code{RBesT::automixfit()}.}

\item{newTrialData}{A vector summarising the new trial data. See \code{createNewTrialData()}.}

\item{weights}{A vector containing the weights to be assigned to the informative component.}

\item{nullTreatmentEffect}{The null treatment effect. Defaults to 0.}

\item{sigma}{Sampling standard deviation for \code{RBesT::robustify()}.}

\item{mceErrorMargin}{Proportion of the SD that the Monte Carlo Error should be smaller than. Defaults to 0.05.}
}
\value{
Averaged quantiles of posteriors created with different weights. Monte Carlo error is also returned.
}
\description{
Runs Monte Carlo simulations with different weights on the informative component of the MAP prior and averages over them.
Weights may be drawn from the pooled distribution of expert-weightings obtained in an expert-elicitation exercise.
}
\examples{

newTrialData <- createNewTrialData(
  nTotal = 30,
  treatmentEffectEstimate = 1.27, standardError = 0.95
)

mapPrior <- loadTipmapData("tipmapPrior.rds")

expertWeights <- rbind(
  c(0, 0, 0, 0, 2, 3, 3, 2, 0, 0),
  c(0, 0, 0, 1, 2, 4, 2, 1, 0, 0),
  c(0, 0, 0, 2, 2, 2, 2, 2, 0, 0)
)

createStochasticWeightPosterior(
  mapPrior = mapPrior, newTrialData = newTrialData,
  weights = drawExpertWeightSample(expertWeights, n = 500), sigma = 12
)

}
\seealso{
\code{\link{createNewTrialData}}, \code{\link[RBesT:automixfit]{RBesT::automixfit}}, \code{\link[RBesT:robustify]{RBesT::robustify}}
}
