% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_beta_mixture_1sample.R
\name{draw_beta_mixture_1sample}
\alias{draw_beta_mixture_1sample}
\title{Draw a single sample from a mixture of beta distributions}
\usage{
draw_beta_mixture_1sample(params, weights = NULL)
}
\arguments{
\item{params}{Dataframe with parameters of beta distributions. Parameters need to be provided in columns named "alpha" and "beta", repectively, i.e. with one row per distribution).}

\item{weights}{Optional vector of weights assigned to experts. Defaults to equal weights.}
}
\value{
One draw (numeric value) from a mixture of beta distributions.
}
\description{
Internal function needed for expert elicitation methods.
}
\examples{
beta_fits <- fit_beta_mult_exp(
chips_mult =
  rbind(
      c(0, 0, 0, 0, 2, 3, 3, 2, 0, 0),
      c(0, 0, 0, 1, 2, 4, 2, 1, 0, 0),
      c(0, 0, 0, 2, 2, 2, 2, 2, 0, 0)
      )
  )
draw_beta_mixture_1sample(beta_fits)

}
