% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tip.R
\name{tip}
\alias{tip}
\alias{tip_with_continuous}
\alias{tip_c}
\title{Tip a result with a continuous confounder.}
\usage{
tip(
  d,
  smd = NULL,
  outcome_association = NULL,
  verbose = TRUE,
  lb_name = "conf.low",
  ub_name = "conf.high"
)

tip_with_continuous(
  d,
  smd = NULL,
  outcome_association = NULL,
  verbose = TRUE,
  lb_name = "conf.low",
  ub_name = "conf.high"
)

tip_c(
  d,
  smd = NULL,
  outcome_association = NULL,
  verbose = TRUE,
  lb_name = "conf.low",
  ub_name = "conf.high"
)
}
\arguments{
\item{d}{Data frame. A data frame with the observed effect(s). This should have
at least two columns with the lower and upper confidence bounds. These
columns are assumed to be called \code{conf.low} and \code{conf.high}. If this
is not the case, the names can be changed using the \code{lb_name} and
\code{ub_name} parameters.}

\item{smd}{Numeric. Estimated scaled mean difference between the
unmeasured confounder in the exposed population and unexposed population}

\item{outcome_association}{Numeric positive value. Estimated association
between the unmeasured confounder and the outcome}

\item{verbose}{Logical. Indicates whether to print informative message.
Default: \code{TRUE}}

\item{lb_name}{Character. Column name of \code{d} that holds the lower
confidence bound. Default: \code{conf.low} based on \code{broom} defaults.}

\item{ub_name}{Character. Column name of \code{d} that holds the upper
confidence bound. Default: \code{conf.high} based on \code{broom} defaults.}
}
\value{
Data frame.
}
\description{
choose one of the following, and the other will be estimated:
\itemize{
\item \code{smd}
\item \code{outcome_association}
}
}
\examples{
d <- data.frame(conf.low = 1.2, conf.high = 1.5)
## to estimate the association between an unmeasured confounder and outcome
## needed to tip analysis
tip(d, smd = -2)

## to estimate the number of unmeasured confounders specified needed to tip
## the analysis
tip(d, smd = -2, outcome_association = .99)

## Example with broom
if (requireNamespace("broom", quietly = TRUE) &&
    requireNamespace("dplyr", quietly = TRUE)) {
  glm(am ~ mpg, data = mtcars, family = "binomial") \%>\%
   broom::tidy(conf.int = TRUE, exponentiate = TRUE) \%>\%
   dplyr::filter(term == "mpg") \%>\%
   tip(outcome_association = 2.5)
}
}
