% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tip.R
\name{tip_rr}
\alias{tip_rr}
\title{Tip an observed relative risk with a normally distributed confounder.}
\usage{
tip_rr(effect, smd = NULL, outcome_association = NULL, verbose = TRUE)
}
\arguments{
\item{effect}{Numeric positive value. Observed exposure - outcome relative risk.
This can be the point estimate, lower confidence bound, or upper
confidence bound.}

\item{smd}{Numeric. Estimated difference in scaled means between the
unmeasured confounder in the exposed population and unexposed population}

\item{outcome_association}{Numeric positive value. Estimated association
between the unmeasured confounder and the outcome}

\item{verbose}{Logical. Indicates whether to print informative message.
Default: \code{TRUE}}
}
\value{
Data frame.
}
\description{
choose one of the following, and the other will be estimated:
\itemize{
\item \code{smd}
\item \code{outcome_association}
}
}
\examples{
## to estimate the association between an unmeasured confounder and outcome
## needed to tip analysis
tip_rr(1.2, smd = -2)

## to estimate the number of unmeasured confounders specified needed to tip
## the analysis
tip_rr(1.2, smd = -2, outcome_association = .99)

}
