% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minhash_v2.R
\name{hash_signature}
\alias{hash_signature}
\title{Function to take a signature matrix M composed of b bands and r rows and return
a bucket for each band for each record}
\usage{
hash_signature(signature, b)
}
\arguments{
\item{signature}{Signature matrix M composed of b bands and r rows}

\item{b}{Number of bands}
}
\value{
Bucket for each band for each record
}
\description{
Function to take a signature matrix M composed of b bands and r rows and return
a bucket for each band for each record
}
\examples{
head(data <- RLdata500[-c(2,4)])
minidata <- data[1:2,]
head(all_the_shingles <- apply(minidata,1,shingles,k=8))
head(minhash.minidata <- minhash_v2(all_the_shingles, p=10))
hash_signature(minhash.minidata, b=2)
hash_signature(minhash.minidata, b=5)
}
