% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/animation_tmap.R
\name{animation_tmap}
\alias{animation_tmap}
\title{Create animations}
\usage{
animation_tmap(expr, width = 1000, height = 1000, delay = 40,
  filename = "animation.gif")
}
\arguments{
\item{expr}{R expression to create series of tmap plots. In order to create a series of tmap plots, which will be the frames of the animation, it is important to set nrow and ncol in \code{\link{tm_facets}}, for otherwise a small multiples plot is generated. Commonly, where one map is shown at a time, both nrow and ncol are set to 1.}

\item{width}{width of the animation file (in pixels)}

\item{height}{height of the animation file (in pixels)}

\item{delay}{delay time between images (in 1/100th of a second)}

\item{filename}{filename of the video (should be a .gif or .mpg file)}
}
\description{
Create a gif or mpeg animation from a tmap plot. The free tool ImageMagick is required.
}
\note{
Not only tmap plots are supported, but any series of R plots.
}
\examples{
\dontrun{
data(Europe)

animation_tmap({
	tm_shape(Europe) +
		tm_fill("yellow") +
		tm_borders() +
		tm_facets(by = "name", nrow=1,ncol=1) +
		tm_layout(scale=2)
}, width=1200, height=800, delay=100, filename="European countries.gif")
}
}
\keyword{animation}

