% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/map_points_to_line.R
\name{map_points_to_line}
\alias{map_points_to_line}
\title{Map points to line}
\usage{
map_points_to_line(shp.points, shp.lines, by.key = FALSE, key.points = NULL,
  key.lines = NULL)
}
\arguments{
\item{shp.points}{shape object containing the points, i.e. a \code{\link[sp:SpatialPointsDataFrame]{SpatialPoints(DataFrame)}}}

\item{shp.lines}{shape object containing the polylines, i.e. a \code{\link[sp:SpatialLinesDataFrame]{SpatialLines(DataFrame)}}}

\item{by.key}{should the points be mapped to the polylines by class (determined by \code{key.points} and \code{key.lines})?}

\item{key.points}{name of a variable contained in \code{shp.points} that determined the classes of the points. The points are mapped to the polylines class-wise.}

\item{key.lines}{name of a variable contained in \code{shp.lines} that determined the classes of the polylines. The points are mapped to the polylines class-wise.}
}
\value{
data.frame, where the rows correspond to the points. The columns are: 1) id1, which is the Lines identifier in which the coordination point is contained, 2) id2, which is the Line identifier in which the coordination point is contained, 3) id3, which is the number of the closest coordination point in the polyline, 4) the distance with the closest coordination point.
}
\description{
Map points to a polyline. For each point, the closest point on the line and the corresponding distance is determined. At the moment, it only considers the begin- joint-, and endpoint coordinates of a line, not their interpolations. To take the interpolations into account, use \code{\link{split_lines_equal}}. (Experimental, see note)
}
\note{
This function is still in experimental phase, which means that it may not be stable and it may be changed significantly in future versions. Moreover, it is unsure if it will stay in tmap; instead, it may be put in a different package, along with functions of similar tasks.
}

