% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tm_misc_elements.R
\name{tm_credits}
\alias{tm_credits}
\title{Credits text}
\usage{
tm_credits(text, size = 0.7, position = c("right", "bottom"),
  bg.color = NA, bg.alpha = NA)
}
\arguments{
\item{text}{text}

\item{size}{relative text size}

\item{position}{position of the text. Vector of two values, specifing the x and y coordinates. Either this vector contains "left", "center" or "right" for the first value and "top", "center", or "bottom" for the second value, or this vector contains two numeric values between 0 and 1 that specifies the x and y value of the center of the text. By default, it is placed in the right bottom corner.}

\item{bg.color}{background color for the text}

\item{bg.alpha}{Transparency number between 0 (totally transparent) and 1 (not transparent). By default, the alpha value of the \code{bg.color} is used (normally 1).}
}
\description{
Creates a text annotation that could be used for credits or acknowledgements.
}
\examples{
data(NLD_muni)
data(NLD_prov)

tm_shape(NLD_muni) +
    tm_fill(col="population", convert2density=TRUE, 
        style="kmeans", title="Population (per km2)") +
    tm_borders("grey25", alpha=.5) + 
    tm_shape(NLD_prov) +
    tm_borders("grey40", lwd=2) +
tm_layout_NLD(bg.color="white", draw.frame = TRUE) +
tm_credits("(c) Statistics Netherlands (CBS) and\\nKadaster Nederland", position=c("left", "bottom"))
}

