% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_layout.R
\name{tm_view}
\alias{tm_view}
\title{View mode options}
\usage{
tm_view(
  use_browser,
  use_WebGL,
  control.position,
  control.bases,
  control.overlays,
  control.collapse,
  set_bounds,
  set_view,
  set_zoom_limits,
  use_circle_markers,
  leaflet.options,
  ...
)
}
\arguments{
\item{use_browser}{If \code{TRUE} it opens an external browser, and \code{FALSE} (default) it opens the internal IDEs (e.g. RStudio) browser.}

\item{use_WebGL}{use webGL for points, lines, and polygons. For large spatial objects, this is much faster than the standard leaflet layer functions. However, it can not always be used for two reasons. First, the number of visual variables are limited; only fill, size, and color (for lines) are supported. Second, projected CRS's are not supported. Furthermore, it has the drawback that polygon borders are not as sharp. By default only \code{TRUE} for large spatial objects (500 or more features) when the mentioned criteria are met.
By default \code{TRUE} if no other visual variables are used.}

\item{control.position}{The position of the control. A tm_pos object, or a shortcut of two values: horizontal (left, center, right) and vertical (top, center, bottom). See tm_pos for details}

\item{control.bases}{base layers}

\item{control.overlays}{overlay layers}

\item{control.collapse}{Should the box be collapsed or expanded?}

\item{set_bounds}{logical that determines whether maximum bounds are set,
or a bounding box. Not applicable in plot mode.
In view mode, this is passed on to \link[leaflet:map-methods]{setMaxBounds()}}

\item{set_view}{numeric vector that determines the view.
Either a vector of three: \code{lng}, \code{lat}, and \code{zoom}, or a single value:
\code{zoom}. See \link[leaflet:map-methods]{setView()}.
Only applicable if \code{bbox} is not specified}

\item{set_zoom_limits}{numeric vector of two that set the minimum and maximum
zoom levels (see \link[leaflet:map-options]{tileOptions()}).}

\item{use_circle_markers}{If \code{TRUE} (default) circle shaped symbols (e.g. \code{tm_dots()} and \code{tm_symbols()}) will be rendered as \link[leaflet:map-layers]{addCircleMarkers()} instead of \link[leaflet:map-layers]{addMarkers()}. The former is faster, the latter can support any symbol since it is based on icons}

\item{leaflet.options}{options passed on to
\link[leaflet:leaflet]{leafletOptions()}}

\item{...}{to catch deprecated arguments}
}
\description{
View mode options. These options are specific to the view mode.
}
\seealso{
\code{\link[=tm_group]{tm_group()}}
}
